class Item_Health extends TournamentHealth;

#exec mesh import mesh=HealthItem anivfile=Models\HealthItem_a.3d datafile=Models\HealthItem_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=HealthItem x=0 y=0 z=0
#exec mesh sequence mesh=HealthItem seq=All startframe=0 numframes=1

#exec meshmap new meshmap=HealthItem mesh=HealthItem
#exec meshmap scale meshmap=HealthItem x=0.03125 y=0.03125 z=0.06250

var int MaxPlayerHealth;

auto state Pickup
{	
	function Touch( actor Other )
		{
		local int HealMax;
		local Pawn P;
			
		if ( Other.IsA('Bot') || Other.IsA('PlayerPawn') ) 
			{	
			P = Pawn(Other);	

			P.Health += HealingAmount;

			if ( P.Health > MaxPlayerHealth )
				P.Health = MaxPlayerHealth;

			PlayPickupMessage(P);
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();
			}
		}
}

defaultproperties
{
     HealingAmount=50
     PickupMessage="You picked up a Health Bonus +"
     ItemName="Health Item"
     RespawnTime=0.000000
     PickupViewMesh=Mesh'HealthItem'
     PickupSound=Sound'Botpack.Pickups.UTHealth'
     Mesh=Mesh'HealthItem'
     ScaleGlow=2.000000
     MultiSkins(0)=Texture'Item_Health'
     CollisionRadius=16.00000
     CollisionHeight=16.00000
     bCollideWhenPlacing=True
     bRotatingPickup=True
     RotationRate=(Roll=32768)
     RotationRate=(Pitch=26000)
     RotationRate=(Yaw=19200)
     LightEffect=LE_Shock
     LightBrightness=64
     LightHue=255
     LightRadius=16
     LightSaturation=127
     LightType=LT_Steady
}
